/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.clientsort.inventory.sort;

import dev.terminalmc.clientsort.config.Config;
import dev.terminalmc.clientsort.inventory.sort.SortContext;
import dev.terminalmc.clientsort.util.item.CreativeSearchOrder;
import dev.terminalmc.clientsort.util.item.StackComparison;
import dev.terminalmc.clientsort.util.item.StackMatcher;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_7706;
import net.minecraft.class_7923;

public abstract class SortOrder {
    public static final Map<String, SortOrder> SORT_MODES = new HashMap<String, SortOrder>();
    public static final SortOrder NONE = SortOrder.register("none", new SortOrder("none"){});
    public static final SortOrder ALPHABET = SortOrder.register("alphabet", new SortOrder("alphabet"){

        @Override
        public int[] sort(int[] sortIds, class_1799[] stacks, SortContext context) {
            String[] strings = new String[sortIds.length];
            for (int i = 0; i < sortIds.length; ++i) {
                class_1799 stack = stacks[i];
                strings[i] = stack.method_7960() ? "" : stack.method_7964().getString();
            }
            IntArrays.quickSort((int[])sortIds, (a, b) -> {
                if (strings[a].isEmpty()) {
                    if (strings[b].isEmpty()) {
                        return 0;
                    }
                    return 1;
                }
                if (strings[b].isEmpty()) {
                    return -1;
                }
                int comp = strings[a].compareToIgnoreCase(strings[b]);
                if (comp == 0) {
                    return StackComparison.compareEqualItems(stacks[a], stacks[b]);
                }
                return comp;
            });
            return sortIds;
        }
    });
    public static final SortOrder CREATIVE = SortOrder.register("creative", new SortOrder("creative"){

        @Override
        public int[] sort(int[] sortIds, class_1799[] stacks, SortContext context) {
            int[] sortValues = new int[sortIds.length];
            if (Config.options().optimizedCreativeSorting) {
                Lock lock = CreativeSearchOrder.getReadLock();
                lock.lock();
                for (int i = 0; i < stacks.length; ++i) {
                    sortValues[i] = CreativeSearchOrder.getPosition(stacks[i]);
                }
                lock.unlock();
            } else {
                Collection displayStacks = class_7706.method_47344().method_47313();
                ArrayList displayStackList = displayStacks instanceof List ? (ArrayList)displayStacks : new ArrayList(displayStacks);
                Object2IntOpenHashMap lookup = new Object2IntOpenHashMap(stacks.length);
                for (int i = 0; i < stacks.length; ++i) {
                    class_1799 stack = stacks[i];
                    sortValues[i] = lookup.computeIfAbsent((Object)StackMatcher.of(stack), arg_0 -> 3.lambda$sort$1(displayStackList, (Object2IntMap)lookup, stack, arg_0));
                }
            }
            SortOrder.sortByValues(sortIds, sortValues, stacks);
            return sortIds;
        }

        private static /* synthetic */ int lambda$sort$1(List displayStackList, Object2IntMap lookup, class_1799 stack, Object matcher) {
            int index = displayStackList.indexOf(matcher);
            if (index != -1) {
                return index;
            }
            return lookup.computeIfAbsent((Object)StackMatcher.ignoreNbt(stack), altMatcher -> {
                int plainIndex = displayStackList.indexOf(altMatcher);
                if (plainIndex == -1) {
                    return Integer.MAX_VALUE;
                }
                return plainIndex;
            });
        }
    });
    public static final SortOrder QUANTITY = SortOrder.register("quantity", new SortOrder("quantity"){

        @Override
        public int[] sort(int[] sortIds, class_1799[] stacks, SortContext context) {
            HashMap<class_1792, Integer> itemToAmountMap = new HashMap<class_1792, Integer>();
            for (class_1799 stack : stacks) {
                if (stack.method_7960()) continue;
                if (!itemToAmountMap.containsKey(stack.method_7909())) {
                    itemToAmountMap.put(stack.method_7909(), stack.method_7947());
                    continue;
                }
                itemToAmountMap.put(stack.method_7909(), (Integer)itemToAmountMap.get(stack.method_7909()) + stack.method_7947());
            }
            IntArrays.quickSort((int[])sortIds, (a, b) -> {
                class_1799 stack = stacks[a];
                class_1799 stack2 = stacks[b];
                if (stack.method_7960()) {
                    return stack2.method_7960() ? 0 : 1;
                }
                if (stack2.method_7960()) {
                    return -1;
                }
                Integer amountA = (Integer)itemToAmountMap.get(stack.method_7909());
                Integer amountB = (Integer)itemToAmountMap.get(stack2.method_7909());
                int cmp = Integer.compare(amountB, amountA);
                if (cmp != 0) {
                    return cmp;
                }
                return StackComparison.compareEqualItems(stack, stack2);
            });
            return sortIds;
        }
    });
    public static final SortOrder RAW_ID = SortOrder.register("rawId", new SortOrder("rawId"){

        @Override
        public int[] sort(int[] sortIds, class_1799[] stacks, SortContext context) {
            int[] rawIds = Arrays.stream(stacks).mapToInt(stack -> stack.method_7960() ? Integer.MAX_VALUE : class_7923.field_41178.method_10206((Object)stack.method_7909())).toArray();
            SortOrder.sortByValues(sortIds, rawIds, stacks);
            return sortIds;
        }
    });
    public final String name;

    public static <T extends SortOrder> T register(String name, T sortOrder) {
        SORT_MODES.put(name, sortOrder);
        return sortOrder;
    }

    public static void unregister(String name) {
        SORT_MODES.remove(name);
    }

    protected SortOrder(String name) {
        this.name = name;
    }

    public int[] sort(int[] sortIds, class_1799[] stacks, SortContext context) {
        return sortIds;
    }

    private static void sortByValues(int[] sortIds, int[] values, class_1799[] stacks) {
        IntArrays.quickSort((int[])sortIds, (a, b) -> {
            int cmp = Integer.compare(values[a], values[b]);
            if (cmp != 0) {
                return cmp;
            }
            return StackComparison.compareEqualItems(stacks[a], stacks[b]);
        });
    }
}

